/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers.armor;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import slimeknights.tconstruct.TConstruct;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.modules.technical.ArmorLevelModule;
import slimeknights.tconstruct.library.module.HookProvider;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;

public class ArmorIncandescentModifier
extends Modifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> INCANDESCENT = TConstruct.createKey((String)"incandescent_armor");

    public ArmorIncandescentModifier() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, ArmorIncandescentModifier::onHurt);
        MinecraftForge.EVENT_BUS.addListener(ArmorIncandescentModifier::onUpdateApply);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addModule((HookProvider)new ArmorLevelModule(INCANDESCENT, false, null));
    }

    private static void onHurt(LivingHurtEvent event) {
        LivingEntity living = event.getEntity();
        Entity attacker = event.getSource().m_7639_();
        living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
            int level = (Integer)holder.get(INCANDESCENT, (Object)0);
            if (level > 0 && attacker != null) {
                attacker.m_20254_((int)event.getAmount());
                attacker.m_6469_(DamageSource.f_19307_, event.getAmount() * 0.1f * (float)level);
            }
        });
    }

    private static void onUpdateApply(LivingEvent.LivingTickEvent evt) {
        EquipmentContext context;
        LivingEntity living = evt.getEntity();
        if (!living.m_5833_() && (context = new EquipmentContext(living)).hasModifiableArmor() && !living.f_19853_.f_46443_ && living.m_6084_() && living.f_19797_ % 80 == 0) {
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
                int level = (Integer)holder.get(INCANDESCENT, (Object)0);
                if (level > 0) {
                    float range = 5 + 3 * level;
                    List ens = living.f_19853_.m_45976_(Mob.class, new AABB(living.m_20185_() - (double)range, living.m_20186_() - (double)range, living.m_20189_() - (double)range, living.m_20185_() + (double)range, living.m_20186_() + (double)range, living.m_20189_() + (double)range));
                    if (!ens.isEmpty()) {
                        for (Mob en : ens) {
                            if (en == null) continue;
                            en.m_20254_(2 * level);
                        }
                    }
                    living.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, living.m_20185_() + RANDOM.nextDouble() - 0.5, living.m_20186_() + RANDOM.nextDouble(), living.m_20189_() + RANDOM.nextDouble() - 0.5, 0.0, 0.25, 0.0);
                }
            });
        }
    }
}

